% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umapClustering.R
\name{createDimRedPlotData}
\alias{createDimRedPlotData}
\title{Generate data for dimension reduction plot}
\usage{
createDimRedPlotData(dimRedCoord = NULL, data4dimRed = NULL,
    freqCutoff = c(0,200), excludeTaxa = "None", currentNCBIinfo = NULL)
}
\arguments{
\item{dimRedCoord}{data contains DIM reduction coordinates (from
dimReduction)}

\item{data4dimRed}{data for dimension reduction (from prepareDimRedData())}

\item{freqCutoff}{gene/taxon frequency cutoff range. Any labels that are
outside of this range will be assigned as [Other]}

\item{excludeTaxa}{hide taxa from plot. Default: "None"}

\item{currentNCBIinfo}{table/dataframe of the pre-processed NCBI taxonomy
data (/PhyloProfile/data/preProcessedTaxonomy.txt)}
}
\value{
A plot as ggplot object
}
\description{
Generate data for dimension reduction plot
}
\examples{
rawInput <- system.file(
   "extdata", "test.main.long", package = "PhyloProfile", mustWork = TRUE
)
longDf <- createLongMatrix(rawInput)
data4dimRed <- prepareDimRedData(longDf, "phylum")
dimRedCoord <- dimReduction(data4dimRed)
createDimRedPlotData(dimRedCoord, data4dimRed)
}
\seealso{
\code{\link{prepareDimRedData}}, \code{\link{dimReduction}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
