% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTaxaGroups.R
\name{featureDistTaxPlot}
\alias{featureDistTaxPlot}
\title{Create feature distribution comparison plot}
\usage{
featureDistTaxPlot(data, plotParameters)
}
\arguments{
\item{data}{dataframe for plotting (see ?dataFeatureTaxGroup)}

\item{plotParameters}{plot parameters, including size of x-axis, y-axis,
legend and title; position of legend ("right", "bottom" or "none"); names of
in-group and out-group; flip the plot coordinate ("Yes" or "No").
NOTE: Leave blank or NULL to use default values.}
}
\value{
Distribution plots as a ggplot2 object.
}
\description{
Create protein feature distribution plots between 2 groups of
taxa for a selected gene.
}
\examples{
data("mainLongRaw", package="PhyloProfile")
data <- mainLongRaw
gene <- "101621at6656"
inputFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
type <- "file"
domainDf <- parseDomainInput(gene, inputFile, type)
inGroup <- c("ncbi9606", "ncbi10116")
plotDf <- dataFeatureTaxGroup(data, domainDf, inGroup, gene)
plotParameters <- list(
    "xSize" = 12,
    "ySize" = 12,
    "angle" = 15,
    "legendSize" = 12,
    "inGroupName" = "In-group",
    "outGroupName" = "Out-group",
    "flipPlot" = "No"
)
featureDistTaxPlot(plotDf, plotParameters)
}
\seealso{
\code{\link{dataFeatureTaxGroup}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
