% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_gaussians.R
\name{fit_gaussians}
\alias{fit_gaussians}
\title{Fit a mixture of Gaussians to a chromatogram curve}
\usage{
fit_gaussians(
  chromatogram,
  n_gaussians,
  max_iterations = 10,
  min_R_squared = 0.5,
  method = c("guess", "random"),
  filter_gaussians_center = TRUE,
  filter_gaussians_height = 0.15,
  filter_gaussians_variance_min = 0.1,
  filter_gaussians_variance_max = 50
)
}
\arguments{
\item{chromatogram}{a numeric vector corresponding to the chromatogram trace}

\item{n_gaussians}{the number of Gaussians to fit}

\item{max_iterations}{the number of times to try fitting the curve with
different initial conditions; defaults to 10}

\item{min_R_squared}{the minimum R-squared value to accept when fitting the
curve with different initial conditions; defaults to 0.5}

\item{method}{the method used to select the initial conditions for
nonlinear least squares optimization (one of "guess" or "random"); 
see \code{\link{make_initial_conditions}} for details}

\item{filter_gaussians_center}{true or false: filter Gaussians whose centres
fall outside the bounds of the chromatogram}

\item{filter_gaussians_height}{Gaussians whose heights are below this 
fraction of the chromatogram height will be filtered. Setting this value to
zero disables height-based filtering of fit Gaussians}

\item{filter_gaussians_variance_min}{Gaussians whose variance falls below 
this number of fractions will be filtered. Setting this value to
zero disables filtering.}

\item{filter_gaussians_variance_max}{Gaussians whose variance is above
this number of fractions will be filtered. Setting this value to
zero disables filtering.}
}
\value{
a list with six entries: the number of Gaussians used to fit
the curve; the R^2 of the fit; the number of iterations used to 
fit the curve with different initial conditions; the coefficients of the 
fit model; and the fit curve predicted by the fit model.
}
\description{
Fit mixtures of one or more Gaussians to the curve formed by a chromatogram
profile, using nonlinear least-squares.
}
\examples{
data(scott)
chrom <- clean_profile(scott[1, ])
fit <- fit_gaussians(chrom, n_gaussians = 1)

}
