% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{getDiscography}
\alias{getDiscography}
\alias{getDiscography,ProteoDiscography-method}
\title{Retrieve imported genomic variants, splice-junctions and manual sequences.}
\usage{
getDiscography(x)

\S4method{getDiscography}{ProteoDiscography}(x)
}
\arguments{
\item{x}{(ProteoDiscography): ProteoDiscography object.}
}
\value{
Return a list of imported records, per category (genomic variants, splice-junctions and manual sequences).
}
\description{
Retrieve imported genomic variants, splice-junctions and manual sequences.
}
\examples{

# Import example ProteoDiscography (hg19)
data('ProteoDiscographyExample.hg19', package = 'ProteoDisco')
ProteoDiscographyExample.hg19 <- setTxDb(ProteoDiscographyExample.hg19, TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene)
ProteoDiscographyExample.hg19 <- setGenomicSequences(ProteoDiscographyExample.hg19, BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)

# Retrieve the imported records.
getDiscography(ProteoDiscographyExample.hg19)

}
