% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qunetwork.R
\name{qunetwork}
\alias{Qnetwork}
\alias{Qunetwork}
\alias{network}
\alias{qunetwork}
\title{Construction and visualization of co-expression network}
\usage{
qunetwork(x, BicRes, number = 1:BicRes@Number, groups = c(number[[1]]),
  method = c("pearson", "kendall", "spearman"))
}
\arguments{
\item{x}{The data matrix}

\item{BicRes}{biclust::BiclustResult object}

\item{number}{Which bicluster to be plotted}

\item{groups}{An object that indicates which nodes belong together.}

\item{method}{A character string indicating
which correlation coefficient (or covariance) is to be computed.
One of 'pearson' (default), 'kendall', or 'spearman', can be abbreviated.}
}
\value{
a list contains a weights matrix and groupinfo
}
\description{
This function can automatically create co-expression networks along with their visualization based on identified biclusters in QUBIC.
Three correlation methods, Pearson, Kendall and Spearman, are available for a user, facilitating different preferences in practical usage.
}
\examples{
# Load microarray matrix
data(BicatYeast)
res <- biclust::biclust(BicatYeast[1:50, ], method=BCQU(), verbose = FALSE)
# Constructing the networks for the 4th and 13th identified biclusters.
net <- qunetwork(BicatYeast[1:50, ], res, number = c(4, 13), group = c(4, 13), method = 'spearman')
\dontrun{
if (requireNamespace('qgraph'))
    qgraph::qgraph(net[[1]], groups = net[[2]], layout = 'spring', minimum = 0.6,
       color = cbind(rainbow(length(net[[2]]) - 1),'gray'), edge.label = FALSE)

}
\dontrun{
#Load microarray matrix
data(BicatYeast)
res <- biclust::biclust(BicatYeast[1:50, ], method=BCQU(), verbose = FALSE)
# Constructing the networks for the 4th and 13th identified biclusters,
#   using the whole network as a background.
net <- qunetwork(BicatYeast[1:50, ], res, group = c(4, 13), method = 'spearman')
if (requireNamespace('qgraph'))
    qgraph::qgraph(net[[1]], groups = net[[2]], layout = 'spring', minimum = 0.6,
       color = cbind(rainbow(length(net[[2]]) - 1),'gray'), edge.label = FALSE)
}
}
\seealso{
\code{\link{qunet2xml}} \code{\link{QUBIC}} \code{\link{cor}}
}

