% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{addGDSRef}
\alias{addGDSRef}
\title{Create a "sample.ref" node i a GDS file with the information about
the related/unrelated state of the reference samples}
\usage{
addGDSRef(gdsReference, filePart)
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened GDS file.}

\item{filePart}{a \code{character} string representing the path and file
name of a RDS file containing the information about the related and
unrelated samples in the reference dataset. The RDS file must exist. The
RDS file must contains a \code{vector} of \code{character} strings called
"unrels" with the name of the unrelated samples.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function creates a "sample.ref" node in the GDS file.
The node contains a vector of integers with value of 1 when
the samples are used as references and 0 otherwise.
The information used to fill the "sample.ref" node comes from the RDS file
that contains the information about the unrelated reference samples.
}
\examples{

## Required library
library(gdsfmt)

## Locate RDS with unrelated/related status for Reference samples
dataDir <- system.file("extdata", package="RAIDS")
rdsFilePath <- file.path(dataDir, "unrelatedPatientsInfo_Demo.rds")

## Temporary GDS file
gdsFilePath <- file.path(tempdir(), "GDS_TEMP_11.gds")

## Create and open the GDS file
tmpGDS  <- createfn.gds(filename=gdsFilePath)
## Create "sample.id" node (the node must be present)
sampleIDs <- c("HG00104", "HG00109", "HG00110")
add.gdsn(node=tmpGDS, name="sample.id", val=sampleIDs)

## Create "sample.ref" node in GDS file using RDS information
RAIDS:::addGDSRef(gdsReference=tmpGDS, filePart=rdsFilePath)

## Read sample reference data.frame
read.gdsn(index.gdsn(node=tmpGDS, path="sample.ref"))

## Close GDS file
closefn.gds(gdsfile=tmpGDS)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
