% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{addStudyGDSSample}
\alias{addStudyGDSSample}
\title{Add information related to a specific study and specific samples
into a GDS Sample file}
\usage{
addStudyGDSSample(gdsProfile, pedProfile, batch, listSamples, studyDF, verbose)
}
\arguments{
\item{gdsProfile}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened GDS file.}

\item{pedProfile}{a \code{data.frame} with the sample information. The
\code{data.frame} must have the columns:
"Name.ID", "Case.ID", "Sample.Type", "Diagnosis" and "Source".
The unique sample identifier of the \code{data.frame} is the "Name.ID"
column and the row names of the \code{data.frame} must be the "Name.ID"
values.}

\item{batch}{a \code{integer} corresponding the batch associated to the
study.}

\item{listSamples}{a \code{vector} of \code{character} string representing
the samples (samples identifiers) that are saved into the GDS. All the
samples must be present in the 'pdeDF' \code{data.frame}.
If \code{NULL}, all samples present in the \code{dfPedProfile} are used.}

\item{studyDF}{a \code{data.frame} with at least the 3 columns: "study.id",
"study.desc" and "study.platform". The three columns are in character
string format (no factor).}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function.}
}
\value{
a \code{vector} of \code{character} strings representing the sample
identifiers that have been saved in the GDS Sample file.
}
\description{
This function add entries related to 1) a specific study and
2) specific samples into a GDS Sample file.
The study information is appended to the GDS Sample file "study.list" node
when the node is already present in the file. Otherwise, the node is
created and then, the information is added.
The sample information for all selected samples is appended to the GDS
Sample file "study.annot" node
when the node is already present in the file. Otherwise, the node is
created and then, the information is added.
}
\examples{

## Required library
library(gdsfmt)

## Create a temporary GDS file in an current directory
gdsFilePath <- file.path(tempdir(), "GDS_TEMP_11.gds")

## Create and open the GDS file
tmpGDS  <- createfn.gds(filename=gdsFilePath)

## Create a PED data frame with sample information
ped1KG <- data.frame(Name.ID=c("1KG_sample_01", "1KG_sample_02"),
        Case.ID=c("1KG_sample_01", "1KG_sample_02"),
        Sample.Type=rep("Reference", 2), Diagnosis=rep("Reference", 2),
        Source=rep("IGSR", 2), stringsAsFactors=FALSE)

## Create a Study data frame with information about the study
## All samples are associated to the same study
studyInfo <- data.frame(study.id="Ref.1KG",
        study.desc="Unrelated samples from 1000 Genomes",
        study.platform="GRCh38 1000 genotypes",
        stringsAsFactors=FALSE)

## Add the sample information to the GDS Sample file
## The information for all samples is added (listSamples=NULL)
RAIDS:::addStudyGDSSample(gdsProfile=tmpGDS, pedProfile=ped1KG, batch=1,
        listSamples=NULL, studyDF=studyInfo, verbose=FALSE)

## Read study information from GDS Sample file
read.gdsn(index.gdsn(node=tmpGDS, path="study.list"))

## Read sample information from GDS Sample file
read.gdsn(index.gdsn(node=tmpGDS, path="study.annot"))

## Close GDS file
closefn.gds(gdsfile=tmpGDS)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
