% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelicFraction_internal.R
\encoding{UTF-8}
\name{computeAlleleFraction}
\alias{computeAlleleFraction}
\title{Compute the allelic fraction for
each imbalanced segment}
\usage{
computeAlleleFraction(snpPos, w = 10, cutOff = -3)
}
\arguments{
\item{snpPos}{a \code{data.frame} containing the genotype information for
a SNV dataset.}

\item{w}{a single positive \code{numeric} representing the size of the
window to compute the allelic fraction.
Default: \code{10}.}

\item{cutOff}{a \code{numeric} representing the cut-off for considering
a region imbalanced when comparing likelihood to gave allelic fraction
change and likelihood not to have allelic fraction change.
Default: \code{-3}.}
}
\value{
a \code{matrix} of \code{numeric} with 3 columns where each
row represent a segment
of imbalanced SNVs. The first column represents the position, in
\code{snpPos}, of the first
SNV in the segment. The second column represents the position, in the
\code{snpPos}, of the last SNV in the segment. The third column represents
the lower allelic frequency of the segment and is \code{NA} when the value
cannot be calculated. The value \code{NULL} is
returned when none of the SNVs
tested positive for the imbalance.
}
\description{
This function computes the allelic fraction for each segment
different than 0.5. The allelic fraction of the segment can be decomposed in
sub-segments.
}
\examples{

## Data frame with SNV information for the specified chromosome (chr 1)
snpInfo <- data.frame(cnt.tot=c(41, 17, 27, 15, 11, 37, 16, 32),
    cnt.ref=c(40, 17, 27, 15, 4, 14, 16, 32),
    cnt.alt=c(0, 0, 0, 0, 7, 23, 0, 0),
    snp.pos=c(3722256, 3722328, 3767522, 3868160, 3869467, 4712655,
        6085318, 6213145),
    snp.chr=c(rep(1, 8)),
    normal.geno=c(rep(1, 8)),
    pruned=c(TRUE, TRUE, FALSE, TRUE, FALSE, rep(TRUE, 3)),
    snp.index=c(160, 162, 204, 256, 259, 288, 366, 465),
    keep=rep(TRUE, 8), hetero=c(rep(FALSE, 4), TRUE, TRUE, rep(FALSE, 2)),
    homo=c(rep(TRUE, 4), FALSE, FALSE, TRUE, TRUE),
    lap=rep(-1, 8), LOH=rep(0, 8), imbAR=rep(-1, 8),
    stringAsFactor=FALSE)

## The function returns NULL when there is not imbalanced SNVs
RAIDS:::computeAlleleFraction(snpPos=snpInfo, w=10, cutOff=-3)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
