% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy.R
\encoding{UTF-8}
\name{computeKNNRefSample}
\alias{computeKNNRefSample}
\title{Run a k-nearest neighbors analysis on one specific profile}
\usage{
computeKNNRefSample(
  listEigenvector,
  listCatPop = c("EAS", "EUR", "AFR", "AMR", "SAS"),
  spRef,
  fieldPopInfAnc = "SuperPop",
  kList = seq(2, 15, 1),
  pcaList = seq(2, 15, 1)
)
}
\arguments{
\item{listEigenvector}{a \code{list} with 3 entries:
'sample.id', 'eigenvector.ref' and 'eigenvector'. The \code{list} represents
the PCA done on the 1KG reference profiles and one specific profile
projected onto it. The 'sample.id' entry must contain only one identifier
(one profile).}

\item{listCatPop}{a \code{vector} of \code{character} string
representing the list of possible ancestry assignations. Default:
\code{c("EAS", "EUR", "AFR", "AMR", "SAS")}.}

\item{spRef}{\code{vector} of \code{character} strings representing the
known super population ancestry for the 1KG profiles. The 1KG profile
identifiers are used as names for the \code{vector}.}

\item{fieldPopInfAnc}{a \code{character} string representing the name of
the column that will contain the inferred ancestry for the specified
profile. Default: \code{"SuperPop"}.}

\item{kList}{a \code{vector} of \code{integer} representing  the list of
values tested for the \emph{K} parameter. The \emph{K} parameter represents the
number of neighbors used in the K-nearest neighbor analysis. If \code{NULL},
the value \code{seq(2,15,1)} is assigned.
Default: \code{seq(2,15,1)}.}

\item{pcaList}{a \code{vector} of \code{integer} representing  the list of
values tested for the \emph{D} parameter. The D parameter represents the
number of dimensions used in the PCA analysis.  If \code{NULL},
the value \code{seq(2, 15, 1)} is assigned.
Default: \code{seq(2, 15, 1)}.}
}
\value{
a \code{list} containing 4 entries:
\describe{
\item{\code{sample.id}}{ a \code{vector} of \code{character} strings
representing the identifier of the profile analysed.}
\item{\code{matKNN}}{ a \code{data.frame} containing the super population
inference for the profile for different values of PCA
dimensions \code{D} and k-neighbors values \code{K}. The fourth column title
corresponds to the \code{fieldPopInfAnc} parameter.
The \code{data.frame} contains 4 columns:
\describe{
\item{\code{sample.id}}{ a \code{character} string representing
the identifier of the profile analysed.}
\item{\code{D}}{ a \code{numeric} strings representing
the value of the PCA dimension used to infer the ancestry.}
\item{\code{K}}{ a \code{numeric} strings representing
the value of the k-neighbors used to infer the ancestry..}
\item{\code{fieldPopInfAnc}}{ a \code{character} string representing
the inferred ancestry.}
}
}
}
}
\description{
The function runs k-nearest neighbors analysis on a
one specific profile. The function uses the 'knn' package.
}
\examples{

## Load the demo PCA on the synthetic profiles projected on the
## demo 1KG reference PCA
data(demoPCASyntheticProfiles)

## Load the known ancestry for the demo 1KG reference profiles
data(demoKnownSuperPop1KG)

## The PCA with 1 profile projected on the 1KG reference PCA
## Only one profile is retained
pca <- demoPCASyntheticProfiles
pca$sample.id <- pca$sample.id[1]
pca$eigenvector <- pca$eigenvector[1, , drop=FALSE]

## Projects profile on 1KG PCA
results <- computeKNNRefSample(listEigenvector=pca,
    listCatPop=c("EAS", "EUR", "AFR", "AMR", "SAS"),
    spRef=demoKnownSuperPop1KG, fieldPopInfAnc="SuperPop",
    kList=seq(10, 15, 1), pcaList=seq(10, 15, 1))

## The assigned ancestry to the profile for different values of K and D
head(results$matKNN)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
