% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAIDS.R
\docType{data}
\name{demoPCA1KG}
\alias{demoPCA1KG}
\title{The PCA results of the demo 1KG reference dataset for demonstration purpose.
Beware that the PCA has been run on a very small subset of the
1KG reference dataset
and should not be used to call ancestry inference on a real profile.}
\format{
The \code{list} containing the PCA results for a small subset of
the reference 1KG dataset. The \code{list} contains 2 entries:
\describe{
\item{pruned}{ a \code{vector} of SNV identifiers specifying selected SNVs
for the PCA analysis.}
\item{pca.unrel}{ a \code{snpgdsPCAClass} object containing the eigenvalues
as generated by \link[SNPRelate]{snpgdsPCA} function.}
}
}
\usage{
data(demoPCA1KG)
}
\value{
The \code{list} containing the PCA results for a small subset of
the reference 1KG dataset. The \code{list} contains 2 entries:
\describe{
\item{pruned}{ a \code{vector} of SNV identifiers specifying selected SNVs
for the PCA analysis.}
\item{pca.unrel}{ a \code{snpgdsPCAClass} object containing the eigenvalues
as generated by \link[SNPRelate]{snpgdsPCA} function.}
}
}
\description{
The object is a \code{list}.
}
\details{
This object can be
used to test the \code{\link{computePCAMultiSynthetic}} function.
}
\examples{

## Required library
library(gdsfmt)

## Loading demo PCA on subset of 1KG reference dataset
data(demoPCA1KG)

## Path to the demo Profile GDS file is located in this package
dataDir <- system.file("extdata/demoKNNSynthetic", package="RAIDS")

# The name of the synthetic study
studyID <- "MYDATA.Synthetic"

samplesRM <- c("HG00246", "HG00325", "HG00611", "HG01173", "HG02165",
    "HG01112", "HG01615", "HG01968", "HG02658", "HG01850", "HG02013",
    "HG02465", "HG02974", "HG03814", "HG03445", "HG03689", "HG03789",
    "NA12751", "NA19107", "NA18548", "NA19075", "NA19475", "NA19712",
    "NA19731", "NA20528", "NA20908")
names(samplesRM) <- c("GBR", "FIN", "CHS","PUR", "CDX", "CLM", "IBS",
    "PEL", "PJL", "KHV", "ACB", "GWD", "ESN", "BEB", "MSL", "STU", "ITU",
    "CEU", "YRI", "CHB", "JPT", "LWK", "ASW", "MXL", "TSI", "GIH")

## Open the Profile GDS file
gdsProfile <- snpgdsOpen(file.path(dataDir, "ex1.gds"))

## Projects synthetic profiles on demo 1KG PCA
results <- computePCAMultiSynthetic(gdsProfile=gdsProfile,
    listPCA=demoPCA1KG, sampleRef=samplesRM, studyIDSyn=studyID,
    verbose=FALSE)

## The eigenvectors for the synthetic profiles
head(results$eigenvector)

## Close Profile GDS file (important)
closefn.gds(gdsProfile)

}
\keyword{datasets}
