% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{getBlockIDs}
\alias{getBlockIDs}
\title{Extract the block identifiers for a list of SNVs}
\usage{
getBlockIDs(gdsRefAnnot, snpIndex, blockTypeID)
}
\arguments{
\item{gdsRefAnnot}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the opened Reference SNV Annotation GDS file.}

\item{snpIndex}{a \code{vectcor} of \code{integer} representing the
indexes of the SNVs of interest.}

\item{blockTypeID}{a \code{character} string corresponding to the block
type used to extract the block identifiers. The block type must be
present in the GDS Reference Annotation file.}
}
\value{
a \code{vector} of \code{numeric} corresponding to the
block identifiers for the SNVs of interest.
}
\description{
The function uses the GDS Reference Annotation file to extract
the unique block identifiers for a list of SNVs. The block type that is
going to be used to extract the information has to be provided by the
user.
}
\examples{

# Required library
library(gdsfmt)

## Path to the demo 1KG Annotation GDS file located in this package
dataDir <- system.file("extdata", package="RAIDS")

path1KG <- file.path(dataDir, "tests")
fileAnnotGDS <- file.path(path1KG, "ex1_good_small_1KG_Annot.gds")

gdsRefAnnotation <- openfn.gds(fileAnnotGDS)

## The indexes for the SNVs of interest
snpIndex <- c(1,3,5,6,9)

## Extract the block identifiers for the SNVs represented by their indexes
## for the block created using the genes from Hsapiens Ensembl v86
RAIDS:::getBlockIDs(gdsRefAnnot=gdsRefAnnotation, snpIndex=snpIndex,
                        blockTypeID="GeneS.Ensembl.Hsapiens.v86")

closefn.gds(gdsRefAnnotation)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
