% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic.R
\encoding{UTF-8}
\name{select1KGPopForSynthetic}
\alias{select1KGPopForSynthetic}
\title{Random selection of a specific number of reference profiles in each
subcontinental population present in the 1KG GDS file ( same as select1KGPop
but the function doesn't need gds object as parameters but the file name
of the referenceGDS )}
\usage{
select1KGPopForSynthetic(fileReferenceGDS, nbProfiles)
}
\arguments{
\item{fileReferenceGDS}{a \code{character} string representing the file
name of the Reference GDS file. The file must exist.}

\item{nbProfiles}{a single positive \code{integer} representing the number
of samples that will be selected for each subcontinental population present
in the 1KG GDS file. If the number of samples in a specific subcontinental
population is smaller than the \code{nbProfiles}, the number of samples
selected in this
subcontinental population will correspond to the size of this population.}
}
\value{
a \code{data.frame} containing those columns:
\describe{
\item{sample.id}{ a \code{character} string representing the sample
identifier. }
\item{pop.group}{ a \code{character} string representing the
subcontinental population assigned to the sample. }
\item{superPop}{ a \code{character} string representing the
super-population assigned to the sample. }
}
}
\description{
The function randomly selects a fixed number of reference
for each subcontinental population present in the 1KG GDS file. When a
subcontinental population has less samples than the fixed number, all
samples from the subcontinental population are selected.
}
\examples{

## Required library
library(gdsfmt)

## The number of samples needed by subcontinental population
## The number is small for demonstration purpose
nbProfiles <- 5L

## 1KG GDS Demo file
## This file only one superpopulation (for demonstration purpose)
dataDir <- system.file("extdata", package="RAIDS")
fileGDS <- file.path(dataDir, "PopulationReferenceDemo.gds")

## Extract a selected number of random samples
## for each subcontinental population
## In the 1KG GDS Demo file, there is one subcontinental population
dataR <- select1KGPopForSynthetic(fileReferenceGDS=fileGDS, nbProfiles=nbProfiles)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
