% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_internal.R
\encoding{UTF-8}
\name{validateComputeSyntheticRoc}
\alias{validateComputeSyntheticRoc}
\title{Validate input parameters for computeSyntheticROC() function}
\usage{
validateComputeSyntheticRoc(
  matKNN,
  matKNNAncestryColumn,
  pedCall,
  pedCallAncestryColumn,
  listCall
)
}
\arguments{
\item{matKNN}{a \code{data.frame} containing the inferred ancestry results
for fixed values of \emph{D} and \emph{K}. On of the column names of the
\code{data.frame} must correspond to the \code{matKNNAncestryColumn}
argument.}

\item{matKNNAncestryColumn}{a \code{character} string
representing the
name of the column that contains the inferred ancestry for the specified
synthetic profiles. The column must be present in the \code{matKNN}
argument.}

\item{pedCall}{a \code{data.frame} containing the information about
the super-population information from the 1KG GDS file
for profiles used to generate the synthetic profiles. The \code{data.frame}
must contained a column named as the \code{pedCallAncestryColumn} argument.}

\item{pedCallAncestryColumn}{a \code{character} string representing the
name of the column that contains the known ancestry for the reference
profiles in the Reference GDS file. The column must be present in
the \code{pedCall} argument.}

\item{listCall}{a \code{vector} of \code{character} strings representing
the list of all possible ancestry assignations.}
}
\value{
\code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link[=computeSyntheticROC]{computeSyntheticROC()}} function.
}
\examples{

## Loading demo dataset containing pedigree information for synthetic
## profiles and known ancestry of the profiles used to generate the
## synthetic profiles
data(pedSynthetic)

## Loading demo dataset containing the inferred ancestry results
## for the synthetic data
data(matKNNSynthetic)

## The inferred ancestry results for the synthetic data using
## values of D=6 and K=5
matKNN <- matKNNSynthetic[matKNNSynthetic$K == 6 & matKNNSynthetic$D == 5, ]

## The validation should be successful
RAIDS:::validateComputeSyntheticRoc(matKNN=matKNN,
    matKNNAncestryColumn="SuperPop",
    pedCall=pedSynthetic, pedCallAncestryColumn="superPop",
    listCall=c("EAS", "EUR", "AFR", "AMR", "SAS"))


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
