% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis_functions.R
\name{runReportMetaAnalysis}
\alias{runReportMetaAnalysis}
\title{runReportMetaAnalysis}
\usage{
runReportMetaAnalysis(
  dbPath = "RCAS.sqlite",
  sampleTablePath,
  outDir = getwd(),
  outFile = NULL,
  quiet = FALSE,
  selfContained = TRUE
)
}
\arguments{
\item{dbPath}{Path to the sqlite database generated by RCAS::createDB}

\item{sampleTablePath}{A tab-separated file with two columns (no rownames) 
header 1: sampleName, header 2: sampleGroup}

\item{outDir}{Path to the output directory. (default: current working 
directory)}

\item{outFile}{Name of the output HTML report (by default, the base name of
sampleTablePath value is used to create a name for the HTML report)}

\item{quiet}{boolean value (default: FALSE). If set to TRUE, progress bars 
and chunk labels will be suppressed while knitting the Rmd file.}

\item{selfContained}{boolean value (default: TRUE). By default, the generated
html file will be self-contained, which means that all figures and tables 
will be embedded in a single html file with no external dependencies (See 
rmarkdown::html_document)}
}
\value{
An html generated using rmarkdown/knitr/pandoc that contains 
  interactive figures, tables, and text that provide an overview of the 
  experiment
}
\description{
Generate a stand-alone HTML report with interactive figures and tables from a
pre-calculated RCAS database (using RCAS::createDB) to compare multiple 
samples.
}
\examples{
dbPath <- system.file("extdata", "hg19.RCASDB.sqlite",
package='RCAS') 

#Hint: use RCAS::summarizeDatabaseContent to see which samples have processed
#data in the database. 
summarizeDatabaseContent(dbPath = dbPath)

#Create a data table for samples and their groups sampleGroup field is used
#to group replicates of #the same sample into one group in visualizations. 
#Any arbitrary name can be used for sampleGroup field. However, entries in
#the sampleName field must be available in the queried database
sampleData <- data.frame('sampleName' = c('FUS', 'FMR1'), 
    'sampleGroup' = c('FUS', 'FMR1'), stringsAsFactors = FALSE) 
write.table(sampleData, 'sampleDataTable.tsv', sep = '\t', 
    quote =FALSE, row.names = FALSE)
#Use the generated database to run a report 
runReportMetaAnalysis(dbPath = 'hg19.RCASDB.sqlite', 
    sampleTablePath = 'sampleDataTable.tsv')
}
