% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AspectDependencies.R
\name{referredBy}
\alias{referredBy}
\title{List the aspects that are refered by an other aspect}
\usage{
referredBy(rcx, aspectClasses = getAspectClasses())
}
\arguments{
\item{rcx}{an object of one of the aspect classes (e.g. NodesAspect, EdgesAspect, etc.)}

\item{aspectClasses}{named character; accession names and aspect classes \link{aspectClasses}}
}
\value{
named list; Aspect class names with names of aspect classes, that refer to them.
}
\description{
This function returns a list of all aspects with all present aspects, that refer to it.
As example, the aspect \emph{NodesAspect} is refered by the property \emph{source} and \emph{target} of
the \emph{EdgesAspect} aspect.
}
\note{
Uses \code{\link[=hasIds]{hasIds()}} and \code{\link[=refersTo]{refersTo()}} to determine the referring aspects.
}
\examples{
nodes = createNodes(name = c("ĆDK1","CDK2","CDK3"))
edges = createEdges(source = c(0,0), target = c(1,2))
rcx = createRCX(nodes = nodes, edges = edges)

referredBy(rcx)
}
\seealso{
\code{\link[=hasIds]{hasIds()}}, \code{\link[=idProperty]{idProperty()}}, \code{\link[=refersTo]{refersTo()}}, \code{\link[=maxId]{maxId()}}
}
