% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-HiddenAttributes.R
\name{updateCyHiddenAttributes}
\alias{updateCyHiddenAttributes}
\alias{updateCyHiddenAttributes.CyHiddenAttributesAspect}
\alias{updateCyHiddenAttributes.RCX}
\title{Update Cytoscape hidden attributes}
\usage{
updateCyHiddenAttributes(
  x,
  hiddenAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCyHiddenAttributes}{CyHiddenAttributesAspect}(
  x,
  hiddenAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCyHiddenAttributes}{RCX}(
  x,
  hiddenAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} or \code{\link{CyHiddenAttributes}} object; (to which the new hidden attributes will be added)}

\item{hiddenAttributes}{\code{\link{CyHiddenAttributes}} object; (the new aspect, that will be added)}

\item{replace}{logical; if existing values are updated (or ignored)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \code{name} (and \code{subnetworkId} if present) column are found}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{CyHiddenAttributes}} or \link[=RCX-object]{RCX} object with added hidden attributes
}
\description{
This functions add hidden attributes in the form of a \code{\link{CyHiddenAttributes}} object to an other \code{\link{CyHiddenAttributes}} or an
\link[=RCX-object]{RCX} object.
}
\details{
Cytoscape subnetworks allow to group a set of nodes and corresponding edges together, and network relations define the relations between those
networks.
\code{\link{CyHiddenAttributes}} objects can be added to an \link[=RCX-object]{RCX} or an other \code{\link{CyHiddenAttributes}} object.

In the case, that a \code{\link{CyHiddenAttributes}} object is added to an other, or the \link[=RCX-object]{RCX} object already contains a
\code{\link{CyHiddenAttributes}} object, some attributes might be present in both. By default, the attributes are updated with the values
of the latest one. This can prevented by setting the \emph{replace} parameter to \code{FALSE}, in that case only new attributes are added and
the existing attributes remain untouched.

Furthermore, if duplicated attributes are considered as a preventable mistake, an error can be raised by setting \emph{stopOnDuplicates}
to \code{TRUE}. This forces the function to stop and raise an error, if duplicated attributes are present.
}
\examples{
## For CyHiddenAttributesAspects: 
## prepare some aspects:
hiddenAttributes1 = createCyHiddenAttributes(
  name=c("A","A","B","B"),
  value=list(c("a1","a2"),
             "a with subnetwork",
             "b",
             "b with subnetwork"),
  isList=c(TRUE,FALSE,TRUE,FALSE),
  subnetworkId=c(NA,1,NA,1)
)

## A is updated, C is new 
hiddenAttributes2 = createCyHiddenAttributes(
  name=c("A","A","C"),
  value=list("new a",
             "new a with subnetwork",
             c(1,2)),
  subnetworkId=c(NA,1,NA)
)

## Simply update with new values
hiddenAttributes3 = updateCyHiddenAttributes(hiddenAttributes1, 
                                             hiddenAttributes2)

## Ignore already present keys
hiddenAttributes3 = updateCyHiddenAttributes(hiddenAttributes1, 
                                             hiddenAttributes2, 
                                             replace=FALSE)

## Raise an error if duplicate keys are present
try(updateCyHiddenAttributes(hiddenAttributes1, hiddenAttributes2, 
                             stopOnDuplicates=TRUE))
## =>ERROR: 
## Elements of "name" and "subnetworkId" (in updateCyHiddenAttributes) 
## must not contain duplicates!

## For RCX
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)
cySubNetworks = createCySubNetworks(
  id = c(1,2),
  nodes = list("all", c(1,2,3)),
  edges = list("all", c(0,2))                    
)
rcx = updateCySubNetworks(rcx, cySubNetworks)

## add a network relation
rcx = updateCyHiddenAttributes(rcx, hiddenAttributes1)

## add an additional relation (update with new values)
rcx = updateCyHiddenAttributes(rcx, hiddenAttributes2)

## create a relation with a not existing subnetwork...
hiddenAttributes3 = createCyHiddenAttributes(
  name="X",
  value="new x",
  subnetworkId=9
)

## ...and try to add them
try(updateCyHiddenAttributes(rcx, hiddenAttributes3))
## =>ERROR: 
## Provided IDs of "additionalAttributes$subnetworkId" (in updateCyHiddenAttributes) 
## don't exist in "rcx$cySubNetworks$id"
}
