% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{createNetworkFromIgraph}
\alias{createNetworkFromIgraph}
\title{Create a Cytoscape network from an igraph network}
\usage{
createNetworkFromIgraph(
  igraph,
  title = "From igraph",
  collection = "My Igraph Network Collection",
  base.url = .defaultBaseUrl,
  ...
)
}
\arguments{
\item{igraph}{(igraph) igraph network object}

\item{title}{(char) network name}

\item{collection}{(char) network collection name}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}

\item{...}{params for nodeSet2JSON() and edgeSet2JSON(); see createNetwork}
}
\value{
(int) network SUID
}
\description{
Takes an igraph network and generates data frames for nodes and edges to
send to the createNetwork function.
Returns the network.suid and applies the perferred layout set in Cytoscape preferences.
}
\details{
Vertices and edges from the igraph network will be translated into nodes and edges
in Cytoscape. Associated attributes will also be passed to Cytoscape as node and edge
table columns. Note: undirected networks will be implicitly modeled as directed
in Cytoscape. Conversion back via \code{createIgraphFromNetwork} will result in
a directed network. Also note: igraph attributes of type "other" denoted by "x"
are converted to "String" in Cytoscape.
}
\examples{
\donttest{
library(igraph)
ig <- makeSimpleIgraph()
createNetworkFromIgraph(ig)
}
}
\seealso{
createNetworkFromDataFrames, createIgraphFromNetwork
}
