% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkViews.R
\name{createView}
\alias{createView}
\title{Create Network View}
\usage{
createView(layout = TRUE, network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{layout}{(optional) If TRUE (default), the preferred layout will be 
applied to the new view. If FALSE, no layout will be applied.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
Network view SUID
}
\description{
Create a network view if one does not already exist
}
\details{
For networks larger than the view creation threshold, a network 
view is not created by default.  This function creates a network view if 
one does not already exist.
}
\examples{
\donttest{
getNetworkViews()
}
}
