% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleDefaults.R
\name{setNodeCustomLineChart}
\alias{setNodeCustomLineChart}
\title{Set Node Custom Line Chart}
\usage{
setNodeCustomLineChart(
  columns,
  colors = NULL,
  range = NULL,
  lineWidth = 1,
  rangeAxis = FALSE,
  zeroLine = FALSE,
  axisWidth = 0.25,
  axisColor = "#000000",
  axisFontSize = 1,
  slot = 1,
  style.name = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{columns}{List of node column names to be displayed.}

\item{colors}{(optional) List of colors to be matched with columns or with
range, depending on type. Default is a set of colors from an appropriate 
Brewer palette.}

\item{range}{(optional) Min and max values of chart. Default is to use min
and max from specified data columns.}

\item{lineWidth}{(optional) Width of chart line. Default is 1.0.}

\item{rangeAxis}{(optional) Show axis with range of values. Default is FALSE.}

\item{zeroLine}{(optional) Show a line at zero. Default is FALSE.}

\item{axisWidth}{(optional) Width of axis lines, if shown. Default is 0.25.}

\item{axisColor}{(optional) Color of axis lines, if shown. Default is black.}

\item{axisFontSize}{(optional) Font size of axis labels, if shown. Default 
is 1.}

\item{slot}{(optional) Which custom graphics slot to modify. Slots 1-9 are 
available for independent charts, gradients and images. Default is 1.}

\item{style.name}{(optional) Name of style; default is "default" style}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Makes a line chart per node using specified node table columns by
setting a default custom graphic style.
}
\examples{
\donttest{
setNodeCustomLineChart(c("data1","data2","data3"))
}
}
\seealso{
setNodeCustomPosition, removeNodeCustomGraphics
}
