% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleBypasses.R
\name{setNodePositionBypass}
\alias{setNodePositionBypass}
\title{Set Node Position Bypass}
\usage{
setNodePositionBypass(
  node.names,
  new.x.locations = NULL,
  new.y.locations = NULL,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{node.names}{List of node names or SUIDs}

\item{new.x.locations}{List of x position values, or single value, default is 
current x position}

\item{new.y.locations}{List of y position values, or single value, default is
current y position}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Sets the bypass value of node position for one or more nodes. Only 
applicable if node dimensions are locked. See \code{lockNodeDimensions}.
}
\details{
This method permanently overrides any default values or mappings 
defined for this visual property of the node or nodes specified. This method
ultimately calls the generic function, \link{setNodePropertyBypass}, which 
can be used to set any visual property. To restore defaults and mappings, use
 \link{clearNodePropertyBypass}, see examples.
}
\examples{
\donttest{
setNodePositionBypass('Node 1', 35)
}
}
\seealso{
{
\link{setNodePropertyBypass},
\link{clearNodePropertyBypass}
}
}
