% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REMParcel-class.R, R/generics.R,
%   R/REMParcel-methods.R
\name{REMParcel-class}
\alias{REMParcel-class}
\alias{REMParcel}
\alias{getParcelInfo}
\alias{getRefGene}
\alias{getRE}
\alias{getRECpG}
\alias{getILMN}
\alias{saveParcel}
\alias{saveParcel,REMParcel-method}
\alias{getParcelInfo,REMParcel-method}
\alias{getRefGene,REMParcel-method}
\alias{getRE,REMParcel-method}
\alias{getRECpG,REMParcel-method}
\alias{getILMN,REMParcel-method}
\title{REMParcel instances}
\usage{
REMParcel(
  REtype = "Unknown",
  genome = "Unknown",
  platform = "Unknown",
  RefGene = GRanges(),
  RE = GRanges(),
  RECpG = GRanges(),
  ILMN = GRanges()
)

getParcelInfo(object)

getRefGene(object)

getRE(object)

getRECpG(object)

getILMN(object, ...)

saveParcel(object, ...)

\S4method{saveParcel}{REMParcel}(object, work.dir = tempdir(), verbose = FALSE, ...)

\S4method{getParcelInfo}{REMParcel}(object)

\S4method{getRefGene}{REMParcel}(object)

\S4method{getRE}{REMParcel}(object)

\S4method{getRECpG}{REMParcel}(object)

\S4method{getILMN}{REMParcel}(object, REonly = FALSE)
}
\arguments{
\item{REtype}{Type of RE (\code{"Alu"}, \code{"L1"}, or \code{"ERV"}).}

\item{genome}{Specify the build of human genome. Can be either \code{"hg19"} or \code{"hg38"}.}

\item{platform}{Illumina methylation profiling platform (\code{"450k"} or \code{"EPIC"}).}

\item{RefGene}{refSeq gene annotation data, which can be obtained by \code{\link{fetchRefSeqGene}}.}

\item{RE}{Annotated RE genomic range data, which can be obtained by \code{\link{fetchRMSK}} and annotated
by \code{\link{GRannot}}.}

\item{RECpG}{Genomic range data of annotated CpG site identified in RE DNA sequence, which can
be obtained by \code{\link{findRECpG}} and annotated by \code{\link{GRannot}}.}

\item{ILMN}{Illumina CpG probe genomic range data.}

\item{object}{A \code{REMParcel} object.}

\item{...}{For \code{saveParcel}: other parameters to be passed to the \code{saveRDS} method. See
\code{\link{saveRDS}}.}

\item{work.dir}{For \code{saveParcel}: path to the directory where the generated data will be saved.
If not specified, temporary directory \code{tempdir()} will be used.}

\item{verbose}{For \code{saveParcel}: logical parameter. Should the function be verbose?}

\item{REonly}{For \code{getILMN}: see Accessors.}
}
\value{
An object of class \code{REMParcel} for the constructor.
}
\description{
\code{REMParcel} is a container class to organize required datasets for
RE methylation prediction generated from \code{\link{initREMP}} and used in \code{\link{remp}}.
}
\section{Accessors}{

\describe{
    \item{\code{getParcelInfo(object)}}{Return data type, RE type, and flanking window size information
    of the parcel.}
    \item{\code{getRefGene(object)}}{Return RefSeq gene annotation data.}
    \item{\code{getRE(object)}}{Return RE genomic location data for prediction
    (annotated by refSeq gene database).}
    \item{\code{getRECpG(object)}}{Return RE-CpG genomic location
    data for prediction.}
    \item{\code{getILMN(object, REonly = FALSE)}}{Return Illumina CpG probe genomic
    location data for prediction (annotated by refSeq gene database). If
    \code{REonly = TRUE}, only probes within RE region are returned.}
    }
}

\section{Utilities}{

\describe{
    \item{\code{saveParcel(object, work.dir = tempdir(), verbose = FALSE, ...)}}{Save
    the object to local machine. }
    }
}

\examples{
showClass("REMParcel")
}
