% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcRIVER.R
\name{integratedEM}
\alias{integratedEM}
\title{An iterative expectation-maximization algorithm for RIVER}
\usage{
integratedEM(Feat, Out, lambda, logistic.init, pseudoc, theta.init, costs,
  verbose = FALSE)
}
\arguments{
\item{Feat}{Genomic features (G).}

\item{Out}{Binary values of outlier status (E).}

\item{lambda}{Selected lambda.}

\item{logistic.init}{Smart initialization of beta (parameters between
FR and G) from estimate of beta with E via multivariate logistic
regression.}

\item{pseudoc}{Pseudo count.}

\item{theta.init}{Initial theta (parameters between FR (functionality
of regulatory variant) and E).}

\item{costs}{Candidate penalty parameter values for L2-regularization
within logistic regression.}

\item{verbose}{Logical option for showing extra information on progress.}
}
\value{
Best estimate of beta and theta, final multivariate logistic
        regression model, and posterior probabilities of FR.
}
\description{
\code{integratedEM} iteratively executes e-step and m-step until it
        converges. This is a main function of RIVER.
}
\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
Feat <- scale(t(Biobase::exprs(dataInput))) # genomic features (G)
Out <- as.vector(as.numeric(unlist(dataInput$Outlier))-1) # outlier status (E)
theta.init=matrix(c(.99, .01, .3, .7), nrow=2)
costs <- c(100, 10, 1, .1, .01, 1e-3, 1e-4)
logisticAllCV <- glmnet::cv.glmnet(Feat, Out, lambda=costs, family="binomial",
        alpha = 0, nfolds=10)
emModelAll <- integratedEM(Feat, Out, lambda=logisticAllCV$lambda.min,
        logistic.init=logisticAllCV$glmnet.fit, pseudoc=50, theta=theta.init,
        costs, verbose=FALSE)

}
\seealso{
\code{\link{getFuncRvFeat}}, \code{\link{getFuncRvPosteriors}},
        \code{\link{mleTheta}}, \code{\link{mleBeta}},
        \code{\link[glmnet]{cv.glmnet}},
        and \url{https://github.com/ipw012/RIVER}
}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
