% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImmPortSqlite.R
\name{buildNewSqliteDb}
\alias{buildNewSqliteDb}
\title{buildNewSqliteDb}
\usage{
buildNewSqliteDb(data_dir, db_dir)
}
\arguments{
\item{data_dir}{File directory where the study TSV files are stored}

\item{db_dir}{File directory where the sqlite database will be stored}
}
\value{
The SQLite database name
}
\description{
The function \code{buildSqliteDb} builds a sqlite db of ImmPort study data. It takes in as input the 
study files in the TSV (Tab) format.
}
\examples{
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
# set tab_dir to the folder where the zip files are located
tab_dir <- file.path(studies_dir, "Tab")
# set db_dir to the folder where the database file 'ImmPort.sqlite' should be stored
db_dir <- file.path(studies_dir, "Db")
# build a new ImmPort SQLite database with the data in the downloaded zip files
# dbname <- buildNewSqliteDb(tab_dir, db_dir) 
}

