% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsMs.r
\name{aggregateSpectra}
\alias{aggregateSpectra}
\title{Aggregate analyzed spectra}
\usage{
aggregateSpectra(spec,  addIncomplete=FALSE)
}
\arguments{
\item{spec}{The \code{RmbSpectraSetList} of spectra sets (\code{RmbSpectraSet} objects) to aggregate}

\item{addIncomplete}{Whether or not the peaks from incomplete files (files
for which less than the maximal number of spectra are present)}
}
\value{
A summary \code{data.frame} with all peaks (possibly multiple rows for one m/z value from a spectrum, see below) with columns:
\item{mzFound, intensity}{Mass and intensity of the peak}
\item{good}{if the peak passes filter criteria}
\item{mzCalc, formula, dbe, dppm}{calculated mass, formula, dbe and ppm deviation of the assigned formula}
\item{formulaCount, dppmBest}{Number of matched formulae for this m/z value, and ppm deviation of the best match}
\item{scan, cpdID, parentScan}{Scan number of the child and parent spectrum in the raw file, also the compound ID to which the peak belongs}
\item{dppmRc}{ppm deviation recalculated from the aggregation function}
\item{index}{Aggregate-table peak index, so the table can be subsetted, edited and results reinserted back into this table easily}
Further columns are later added by workflow steps 6 (electronic noise culler), 7 and 8.
}
\description{
Groups an array of analyzed spectra and creates aggregated peak tables
}
\details{
\code{\var{addIncomplete}} is relevant for recalibration. For recalibration,
we want to use only high-confidence peaks, therefore we set
\code{\var{addIncomplete}} to \code{FALSE}. When we want to generate a peak
list for actually generating MassBank records, we want to include all peaks
into the peak tables.
}
\examples{

## As used in the workflow:
\dontrun{\%
	w@spectra <- lapply(w@spectra, function(spec)
		analyzeMsMs(spec, mode="pH", detail=TRUE, run="recalibrated", cut=0, cut_ratio=0 ) )
	w@aggregate <- aggregateSpectra(w@spectra)
}

}
\seealso{
\code{\link{msmsWorkflow}}, \code{\link{analyzeMsMs}}
}
\author{
Michael Stravs
}
