% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msmsRead.R
\name{msmsRead.RAW}
\alias{msmsRead.RAW}
\title{Extracts and processes spectra from a list of xcms-Objects}
\usage{
msmsRead.RAW(
  w,
  xRAW = NULL,
  cpdids = NULL,
  mode,
  findPeaksArgs = NULL,
  settings = getOption("RMassBank"),
  progressbar = "progressBarHook",
  plots = FALSE
)
}
\arguments{
\item{w}{A \code{msmsWorkspace} to work with.}

\item{xRAW}{A list of xcmsRaw objects whose peaks should be detected and added to the workspace.
The relevant data must be in the MS1 data of the xcmsRaw object.  You can coerce the
msn-data in a usable object with the \code{msn2xcmsRaw} function of xcms.}

\item{cpdids}{A vector or list containing the compound IDs of the files that are to be read as spectra.
The ordering of this and \code{files} implicitly assigns each ID to the corresponding file.
If this is supplied, then the IDs implicitly named in the filenames are ignored.}

\item{mode}{\code{"pH", "pNa", "pM", "pNH4", "mH", "mM", "mFA"} for different ions 
([M+H]+, [M+Na]+, [M]+, [M+NH4]+, [M-H]-, [M]-, [M+FA]-).}

\item{findPeaksArgs}{A list of arguments that will be handed to the xcms-method findPeaks via do.call}

\item{settings}{Options to be used for processing. Defaults to the options loaded via
\code{\link{loadRmbSettings}} et al. Refer to there for specific settings.}

\item{progressbar}{The progress bar callback to use. Only needed for specialized applications.
Cf. the documentation of \code{\link{progressBarHook}} for usage.}

\item{plots}{A boolean value that determines whether the pseudospectra in XCMS should be plotted}
}
\value{
The \code{msmsWorkspace} with msms-spectra read.
}
\description{
The filenames of the raw LC-MS runs are read from the array \code{files} 
in the global enviroment.
See the vignette \code{vignette("RMassBank")} for further details about the
workflow.
}
\seealso{
\code{\link{msmsWorkspace-class}}, \code{\link{msmsWorkflow}}
}
\author{
Michael Stravs, Eawag <michael.stravs@eawag.ch>

Erik Mueller, UFZ
}
