% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectraSetMethods.R
\name{selectSpectra}
\alias{selectSpectra}
\alias{selectSpectra,RmbSpectraSetList,character-method}
\alias{selectSpectra,msmsWorkspace,character-method}
\title{Select a subset of spectra matching properties}
\usage{
selectSpectra(s, property, value = "logical")

\S4method{selectSpectra}{RmbSpectraSetList,character}(s, property, value = "logical")

\S4method{selectSpectra}{msmsWorkspace,character}(s, property, value = "logical")
}
\arguments{
\item{s}{The \code{RmbSpectraSetList} or \code{msmsWorkspace} to select \code{RmbSpectraSet}s from.}

\item{property}{The property to check (\code{found}, \code{complete} or \code{empty})}

\item{value}{\code{logical} if a \code{TRUE/FALSE} list should be returned; \code{index} if a vector of matching indices should be returned,
\code{object} if matching objects should be returned, \code{mismatch} if mismatching objects should be returned.}
}
\value{
As described above.
}
\description{
From a list of \code{RmbSpectraSet}s, returns the spectra which match a criterion (found, complete, empty as in \code{\link{checkSpectra}}).
This can be returned either as a \code{TRUE/FALSE} vector, as a vector of indices for matching elements, as a vector of \code{RmbSpectraSet} objects
matching the conditions, or as a vector of \code{RmbSpectraSet} objects NOT matching the conditions (sic!).
}
\section{Methods (by class)}{
\itemize{
\item \code{selectSpectra(s = RmbSpectraSetList, property = character)}: A method for selecting spectra from a spectra set list

\item \code{selectSpectra(s = msmsWorkspace, property = character)}: A method for selecting spectra from an msmsWorkspace

}}
\author{
stravsmi
}
