% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulaCalculator.R
\name{to.limits.rcdk}
\alias{to.limits.rcdk}
\title{Convert formula to Rcdk limits}
\usage{
to.limits.rcdk(formula)
}
\arguments{
\item{formula}{A molecular formula in string or list representation
(\code{"C6H6"} or \code{list(C=6,H=6)}).}
}
\value{
An array in the form \code{c( c("C", "0", "12"), c("H", "0", "12"))}
(for input of "C12H12").
}
\description{
Converts a molecular formula e.g. C15H20 into an upper limit appropriate for
use with Rcdk's \code{\link{generate.formula}} function's \code{element}
argument.
}
\details{
This helper function is used to make the upper limits for
\code{\link{generate.formula}} when finding subformulas to match to a MS2
fragment peak.
}
\examples{

#
to.limits.rcdk("C6H6")
to.limits.rcdk(add.formula("C6H12O6", "H"))

}
\seealso{
\code{\link{generate.formula}}, \code{\link{add.formula}}
}
\author{
Michael Stravs
}
