% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateMassBank.R
\name{validate}
\alias{validate}
\title{Validate MassBank records with a set of Unit tests}
\usage{
validate(path, simple = TRUE)
}
\arguments{
\item{path}{The filepath to a single record, or a directory to search recursively}

\item{simple}{If TRUE the function creates a simpler form of the RUnit .html report, better readable for humans. If FALSE it returns the unchanged RUnit report.}
}
\description{
Validates a plain text MassBank record, or recursively all
records within a directory. The Unit Tests to be used are
installed in RMassBank/inst/validationTests and currently include 
checks for NAs, peaks versus precursor, precursor mz, 
precursor type, SMILES vs exact mass, total intensities and
title versus type. The validation report is saved as 
"report.html" in the working directory.
}
\examples{
\dontrun{
validate("/tmp/MassBank/OpenData/record/")
}
}
