% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPA.preprocess.R
\name{RPA.preprocess}
\alias{RPA.preprocess}
\title{RPA preprocessing}
\usage{
RPA.preprocess(
  abatch,
  bg.method = "rma",
  normalization.method = "quantiles.robust",
  cdf = NULL,
  cel.files = NULL,
  cel.path = NULL,
  quantile.basis = NULL
)
}
\arguments{
\item{abatch}{An AffyBatch object.}

\item{bg.method}{Specify background correction method. See bgcorrect.methods(abatch) for options.}

\item{normalization.method}{Specify normalization method. See normalize.methods(abatch) for options. For memory-efficient online version, use "quantiles.online".}

\item{cdf}{The CDF environment used in the analysis.}

\item{cel.files}{List of CEL files to preprocess.}

\item{cel.path}{Path to CEL file directory.}

\item{quantile.basis}{Optional. Basis for quantile normalization. NOTE: required in original, not log2 scale!}
}
\value{
fcmat: Probes x arrays preprocessed differential expression matrix.
 cind: Specifies which array in abatch was selected as a reference in calculating probe-level differential expression.
 cdf: The CDF environment used in the analysis.
 set.inds: Indices for probes in each probeset, corresponding to the rows of fcmat.
}
\description{
Preprocess AffyBatch object for RPA.
}
\details{
Background correction, quantile normalization and log2-transformation for probe-level raw data in abatch. Then probe-level differential expression is computed between the specified 'reference' array (cind) and the other arrays. Probe-specific variance estimates are robust against the choice of reference array.
}
\examples{
# 
}
\references{
See citation("RPA")
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{methods}
