% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa.plot.R
\name{probeplot}
\alias{probeplot}
\title{probeplot
Plot RPA results and probe-level data for a specified probeset.}
\usage{
probeplot(
  dat,
  highlight.probes = NULL,
  pcol = "darkgrey",
  hcol = "red",
  cex.lab = 1.5,
  cex.axis = 1,
  cex.main = 1,
  cex.names = 1,
  main = "",
  ...
)
}
\arguments{
\item{dat}{Background-corrected and normalized data: probes x samples.}

\item{highlight.probes}{Optionally highlight some of the probes (with dashed line)}

\item{pcol}{Color for probe signal visualization.}

\item{hcol}{Color for probe highlight}

\item{cex.lab}{Label size adjustment parameters.}

\item{cex.axis}{Axis size adjustment parameters.}

\item{cex.main}{Title size adjustment parameters.}

\item{cex.names}{Names size adjustment parameters.}

\item{main}{Title text.}

\item{...}{Other parameters to pass for plot function.}
}
\value{
Used for its side-effects. Returns probes x samples matrix of probe-level data plotted on the image.
}
\description{
probeplot
Plot RPA results and probe-level data for a specified probeset.
}
\details{
Plots the preprocessed probe-level observations, estimated probeset-level signal, and probe-specific variances. It is also possible to highlight individual probes and external summary measures.
}
\examples{
# 
}
\references{
See citation("RPA")
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{methods}
