% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBR-methods.R
\docType{methods}
\name{mbrGet,MBR-method}
\alias{mbrGet,MBR-method}
\alias{mbrGet}
\title{Get information from individual slots in MBR object.}
\usage{
\S4method{mbrGet}{MBR}(object, what = "status")
}
\arguments{
\item{object}{A preprocessed object of class \linkS4class{MBR}}

\item{what}{a single character value specifying which information should be 
retrieved from the slots. Options: "TNI", "regulatoryElements", 
"dualRegulons", "results", "para", "summary", 
"status", "dualsCorrelation", "dualsOverlap", and "dualsCorMatrix"}
}
\value{
Content from slots in the \linkS4class{MBR} object
}
\description{
Get information from individual slots in an MBR object and any available 
results from previous analysis.
}
\examples{
##--- load a dataset for demonstration
data("tniData", package = "RTN")
gexp <- tniData$expData
annot <- tniData$rowAnnotation
tfs <- c("IRF8","IRF1","PRDM1","E2F3","STAT4","LMO4","ZNF552")

##--- construct a tni object
rtni <- tni.constructor(gexp, regulatoryElements = tfs, rowAnnotation=annot)

##--- compute regulons 
## set nPermutations>=1000
rtni <- tni.permutation(rtni, nPermutations=30)
## set nBootstrap>=100
rtni <- tni.bootstrap(rtni, nBootstrap=30)
## 'eps=NA' estimates threshold from empirical null
rtni <- tni.dpi.filter(rtni, eps=NA)

##--- construct a mbr object
rmbr <- tni2mbrPreprocess(rtni)

##--- get the 'TNI' slot using 'mbrGet'
tni <- mbrGet(rmbr, what="TNI")

}
