% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.R
\name{background}
\alias{background}
\title{Randomly choose background genes.}
\usage{
background(Y, nBG, exclude, nc_index)
}
\arguments{
\item{Y}{A matrix of gene expression values or an object of 
the class \code{simulateGEdata}.}

\item{nBG}{An integer setting the number of background genes.}

\item{exclude}{A vector of indices of genes to exclude.}

\item{nc_index}{A vector of indices of negative controls (also
excluded from being background genes).}
}
\value{
\code{background} returns a vector of randomly chosen indices.
}
\description{
\code{background} returns background genes for judging the quality of the cleaning. 
  These genes are supposed to represent the majority of genes. The positive control and 
  negative control genes should be excluded.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)  
background(Y, nBG=20, exclude=1:100, nc_index=251:500)
}
\author{
Saskia Freytag
}
