% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genePlot.R
\name{genePlot}
\alias{genePlot}
\title{Plot of means and inter-quantile ranges of all genes.}
\usage{
genePlot(Y, index = NULL, legend = NULL, col.h = "red", title)
}
\arguments{
\item{Y}{A matrix of gene expression values or an object of the class \code{simualteGEdata}.}

\item{index}{A vector of indices of genes of interest to be displayed in a different color, if \code{index=NULL} no genes are highlighted.}

\item{legend}{A character string describing the highlighted genes.}

\item{col.h}{The color of the highlighted genes.}

\item{title}{A character string describing the title of the plot.}
}
\value{
\code{genePlot} returns a plot.
}
\description{
\code{genePlot} plots the means vs. the inter-quantile ranges of the gene
   expression values of all genes with the possibility to highlight interesting sets of genes.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=TRUE)
try(dev.off(), silent=TRUE)
par(mar=c(5.1, 4.1, 4.1, 2.1), mgp=c(3, 1, 0), las=0)
genePlot(Y, index=1:100, legend="Expressed genes", title="IQR-Mean Plot")
}
\author{
Saskia Freytag
}
