% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwa_build_index.R
\name{bwa_build_index}
\alias{bwa_build_index}
\title{R wrapper to create BWA index files}
\usage{
bwa_build_index(fasta, index_prefix = NULL, ...)
}
\arguments{
\item{fasta}{String specifying path to a FASTA file.}

\item{index_prefix}{String specifying prefix of the output BWA index.}

\item{...}{Other arguments to pass to \code{bwa index}.}
}
\value{
No return value. BWA index files are produced as a side-effect.
}
\description{
R wrapper to create BWA index files from a FASTA file.
}
\examples{
dir <- tempdir()
fasta <- system.file(package="Rbwa",
                     "fasta/chr12.fa")
bwa_build_index(fasta,
                index_prefix=file.path(dir,"chr12"))

}
\author{
Jean-Philippe Fortin
}
