% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RedisBackend-class.R
\name{RedisBackend}
\alias{RedisBackend}
\alias{.recv,RedisBackend-method}
\alias{.send,RedisBackend-method}
\alias{.close,RedisBackend-method}
\alias{.send_to,RedisBackend-method}
\alias{.recv_any,RedisBackend-method}
\alias{.recv_all,RedisBackend-method}
\alias{bpjobname,RedisBackend-method}
\alias{bpworkers,RedisBackend-method}
\title{Creating the Redis backend}
\usage{
RedisBackend(
  RedisParam = NULL,
  jobname = "myjob",
  host = rphost(),
  port = rpport(),
  password = rppassword(),
  timeout = .Machine$integer.max,
  type = c("manager", "worker"),
  id = NULL,
  log = FALSE,
  redis.log = NULL,
  flushInterval = 5L
)

\S4method{.recv}{RedisBackend}(worker)

\S4method{.send}{RedisBackend}(worker, value)

\S4method{.close}{RedisBackend}(worker)

\S4method{.send_to}{RedisBackend}(backend, node, value)

\S4method{.recv_any}{RedisBackend}(backend)

\S4method{.recv_all}{RedisBackend}(backend)

\S4method{bpjobname}{RedisBackend}(x)

\S4method{bpworkers}{RedisBackend}(x)
}
\arguments{
\item{RedisParam}{RedisParam, if this argument is not NULL, all the
other arguments will be ignored except \code{type}.}

\item{jobname}{character(1) The job name used by the manager and
workers to connect.}

\item{host}{character(1) The host of the Redis server.}

\item{port}{integer(1) The port of the Redis server.}

\item{password}{character(1) The password of the redis server.}

\item{timeout}{integer(1) The waiting time in \code{BLPOP}.}

\item{type}{character(1) The type of the backend (manager or worker?).}

\item{id}{character(1) The manager/worker ID. If not given by the
user and the environment \code{REDISPARAM_ID} is not defined, a
random ID will be used}

\item{log}{logical(1) Whether to enable the log}

\item{redis.log}{logical(1) Whether to enable the redis server log}

\item{flushInterval}{numeric(1) The waiting time between two flush operation.}
}
\value{
\code{RedisBackend()} returns an object of class
\code{RedisBackend}. This object is not useful to the end user.
}
\description{
Creating the Redis backend
}
\keyword{internal}
