% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCellTypeSpecificDE_withProp.R
\name{GetCellTypeSpecificDE_withProp}
\alias{GetCellTypeSpecificDE_withProp}
\title{Identify cross-regional cell type-specific differential analysis with proportion}
\usage{
GetCellTypeSpecificDE_withProp(
  sce,
  Regional1ID,
  Regional2ID,
  n_markers = 10,
  angle = 30,
  hjust = 0,
  size = 3,
  padj_filter = 0.05,
  doHeatmap = FALSE
)
}
\arguments{
\item{sce}{A single cell experiment object.}

\item{Regional1ID}{A vector of spot IDs for comparison region 1.}

\item{Regional2ID}{A vector of spot IDs for comparison region 2.}

\item{n_markers}{A number specifying the top DE gene number.}

\item{angle}{A number for angle when plotting.}

\item{hjust}{A number for horizontal justification when plotting.}

\item{size}{A number for text font size.}

\item{padj_filter}{A number for filtering adjusted p values.}

\item{doHeatmap}{Logical variable for whether drawing the heatmap.}
}
\value{
A list including the top DE genes (topDE), and all DE genes (allDE).
}
\description{
Identify cross-regional cell type-specific differential analysis with proportion
}
\examples{
data("example_sce")
example_sce <- mySpatialPreprocess(example_sce, platform="Visium")
thisID1 <- S4Vectors::metadata(example_sce)$selectCenters$selectID[1]
thisRadius1 <- S4Vectors::metadata(example_sce)$selectCenters$selectRadius[1]
OutRegRes1 <- RegionalST::FindRegionalCells(example_sce,
                                            centerID = thisID1,
                                            radius = thisRadius1,
                                            enhanced = FALSE,
                                            doPlot = FALSE,
                                            returnPlot = FALSE)
thisID2 <- S4Vectors::metadata(example_sce)$selectCenters$selectID[2]
thisRadius2 <- S4Vectors::metadata(example_sce)$selectCenters$selectRadius[2]
OutRegRes2 <- RegionalST::FindRegionalCells(example_sce,
                                            centerID = thisID2,
                                            radius = thisRadius2,
                                            enhanced = FALSE,
                                            doPlot = FALSE,
                                            returnPlot = FALSE)
Regional1ID <- OutRegRes1$closeID
Regional2ID <- OutRegRes2$closeID
CTS_DE <- GetCellTypeSpecificDE_withProp(example_sce,
                                         Regional1ID = Regional1ID,
                                         Regional2ID = Regional2ID,
                                         n_markers = 10,
                                         angle = 30,
                                         hjust = 0,
                                         size = 3,
                                         padj_filter = 0.05,
                                         doHeatmap = FALSE)
                                         
}
