% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/megabrowser_internal.R
\name{get_meta_browser_plot_full}
\alias{get_meta_browser_plot_full}
\title{Full plot for allsamples browser}
\usage{
get_meta_browser_plot_full(
  m,
  heatmap,
  id,
  df,
  summary = TRUE,
  annotation = TRUE,
  region_type,
  plotType = "plotly",
  tx_annotation,
  display_region,
  cds_annotation,
  viewMode,
  collapse_intron_flank,
  rel_heights = c(0.2, 0.75, 0.05)
)
}
\arguments{
\item{m}{data.table of coverage per sample (wide format)}

\item{heatmap}{ComplexHeatmap object of plot from 'm'}

\item{id}{id of transcript}

\item{df}{ORFik experiment}

\item{summary}{logical, default TRUE (add top plot)}

\item{annotation}{logical, default TRUE (add bottom annotation track)}

\item{region_type}{character, "what is the coverage region?" Usually full mrna:
"mrna" or "leader+cds".}

\item{plotType}{= "plotly",}

\item{tx_annotation}{a GRangesList of tx annotation}

\item{display_region}{a GRangesList of display region}

\item{cds_annotation}{a GRangesList of cds annotation}

\item{viewMode}{character, "tx" or "genomic"}

\item{collapse_intron_flank}{integer, if TRUE and viewMode genomic, collapse
introns to this max size.}

\item{rel_heights}{numeric < 1, default: c(0.2, 0.75, 0.05).
Relative heights, sum to 1 and must be length 3.}
}
\value{
a cowplot grub
}
\description{
Full plot for allsamples browser
}
