% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBDiffMeth-class.R
\docType{methods}
\name{join.diffMeth,RnBDiffMeth,RnBDiffMeth-method}
\alias{join.diffMeth,RnBDiffMeth,RnBDiffMeth-method}
\alias{join.diffMeth}
\title{join.diffMeth-methods}
\usage{
\S4method{join.diffMeth}{RnBDiffMeth,RnBDiffMeth}(obj1, obj2)
}
\arguments{
\item{obj1}{\code{\linkS4class{RnBDiffMeth}} object. Its base properties will be used to create the joint object
this is particularly imported for disk dumped objects as its path will be used and tables from the second
object will be copied there}

\item{obj2}{\code{\linkS4class{RnBDiffMeth}} object}
}
\value{
the merged \code{\linkS4class{RnBDiffMeth}} object
}
\description{
Merges two disjoint RnBDiffMeth objects into one. Disjoint here means, that no differential methylation table is specified in both
objects.
}
\note{
Caveat: if disk dumping is enabled the resulting object tables will be stored in the initial location of the first object to be joined
I.e. deleting the first object will lead to a broken joined object and deleting the joined object will lead to an broken first object.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm1 <- rnb.execute.computeDiffMeth(rnb.set.example,"Sample_Group",c("genes","tiling"))
dm2 <- rnb.execute.computeDiffMeth(rnb.set.example,c("Sample_Group","Treatment"),"promoters")
dm.join1 <- join.diffMeth(dm1,dm2)
#The following joint object is invalid due to missing region type - comparison combinations
is.valid(dm.join1)
dm3 <- rnb.execute.computeDiffMeth(rnb.set.example,"Treatment",c("genes","tiling"))
dm.join2 <- join.diffMeth(dm.join1,dm3)
#After joining the missing information, the new object is valid
is.valid(dm.join2)
}
}
\author{
Fabian Mueller
}
