% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R, R/RnBeadSet-class.R,
%   R/RnBeadRawSet-class.R
\docType{methods}
\name{remove.samples,RnBSet-method}
\alias{remove.samples,RnBSet-method}
\alias{remove.samples}
\alias{remove.samples,RnBeadSet-method}
\alias{remove.samples,RnBeadRawSet-method}
\title{remove.samples-methods}
\usage{
\S4method{remove.samples}{RnBSet}(object, samplelist)

\S4method{remove.samples}{RnBeadSet}(object, samplelist)

\S4method{remove.samples}{RnBeadRawSet}(object, samplelist)
}
\arguments{
\item{object}{Dataset of interest.}

\item{samplelist}{List of samples to be removed in the form of a \code{logical}, \code{integer} or \code{character}
vector. If this parameter is \code{logical}, it is not recycled; its length must be equal to the
number of samples in \code{object}. If it is \code{integer} or \code{character}, it must list only
samples that exist in the dataset. Specifying sample indices larger than the number of samples, or
non-existent sample identifiers results in an error.}
}
\value{
The modified dataset.
}
\description{
Removes the specified samples from the dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
samples(rnb.set.example)
## remove 3 random samples
s2r<-sample.int(length(samples(rnb.set.example)), 3)
rnb.set.f<-remove.samples(rnb.set.example, s2r)
samples(rnb.set.f)
}
}
\seealso{
\code{\link[=remove.sites,RnBSet-method]{remove.sites}} for removing sites or probes from a methylation dataset
}
