% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.cross.reactive.removal}
\alias{rnb.execute.cross.reactive.removal}
\title{rnb.execute.cross.reactive.removal}
\usage{
rnb.execute.cross.reactive.removal(rnb.set)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBeadSet}}.}
}
\value{
\code{list} of four elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly) modified dataset object after removing probes that have a high
               likelihood of cross-hybridization.}
          \item{\code{"filtered"}}{\code{integer} vector storing the indices (in beta matrix of the unfiltered
               dataset) of all removed probes.}
        }
}
\description{
Removes all probes defined as cross-reactive from the given dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.filtered <- rnb.execute.cross.reactive.removal(rnb.set.example)$dataset
identical(meth(rnb.set.example), meth(rnb.set.filtered)) # FALSE
}
}
\author{
Yassen Assenov
}
