% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.high.dpval.masking}
\alias{rnb.execute.high.dpval.masking}
\title{rnb.execute.high.dpval.masking}
\usage{
rnb.execute.high.dpval.masking(rnb.set, dpval.threshold = 0.05)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBeadSet}}.}

\item{dpval.threshold}{Threshold for maximal acceptable detection p-value, given as a non-negative \code{numeric} value between 0 and 1. All
methylation measurements with detection p-value than this threshold are set to \code{NA}. If this
parameter is \code{0}, calling this method has no effect.}
}
\value{
List of three elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly) modified dataset after retaining sites on autosomes only.}
          \item{\code{"mask"}}{A logical matrix of dimension \code{meth(rnb.set,type="sites")} indicating which
				   methylation values have been masked}
        }
}
\description{
Replaces all low coverage sites by \code{NA}.
}
\author{
Fabian Mueller
}
