% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExport.R
\name{rnb.export.to.trackhub}
\alias{rnb.export.to.trackhub}
\title{rnb.export.to.trackhub}
\usage{
rnb.export.to.trackhub(
  rnb.set,
  out.dir,
  reg.type = "sites",
  data.type = "bigBed",
  ...
)
}
\arguments{
\item{rnb.set}{Object of class \code{\linkS4class{RnBSet}}}

\item{out.dir}{output directory. If not existing, it will be created. otherwise files in that directory are overwritten.}

\item{reg.type}{region type to be converted}

\item{data.type}{either "bigBed" or "bigWig"}

\item{...}{parameters passed on to the track hub generating procedure}
}
\value{
a list containing information on the export
}
\description{
convert an \code{\linkS4class{RnBSet}}  object to a UCSC-style track hub.
}
\details{
During execution the RnBSet is converted to bed files. If the operating system is supported (currently Unix and MacOS only)
         these are automatically converted to bigBed files. If your operating system is not supported, you need to create them manually
         (see the \href{http://genome.ucsc.edu/FAQ/FAQformat.html}{UCSC Genome Browser documentation} for details).
         For details on UCSC track hubs see the
         \href{http://genome.ucsc.edu/goldenPath/help/hgTrackHubHelp.html}{UCSC tracks help page}.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.export.to.trackhub(rnb.set.example,tempdir())
}
}
\author{
Fabian Mueller
}
