##' convertId
##' 
##' A function to convert ID based on the biomaRt package.
##' 
##' A function to convert ID based on the biomaRt package..
##' 
##' @param x the Ids need to be converted.
##' @param verbose Logical. Indicate report extra information on progress or not.
##' @inheritParams biomaRt::getBM
##' @inheritParams biomaRt::useMart
##' @return A converted ID character with the same order of parameter x.
##' @importFrom biomaRt getBM useMart
##' @export
##' @examples 
##' x<-c("Q04837","P0C0L4","P0C0L5","O75379","Q13068","A2MYD1")
##' convertIdOneToOne(x,filters="uniprotswissprot",verbose=TRUE)
convertIdOneToOne<-function(x,dataset="hsapiens_gene_ensembl",filters="uniprotswissprot",attributes =c(filters,"entrezgene_id"),verbose=FALSE) {
	if (verbose) {
		message("Now conectting with ensembl. Internet acess is needed and it may use 30 seconds.")
	  utils::flush.console()
	}
	
	ensembl = biomaRt::useMart("ensembl",dataset=dataset)
	newIdTable<-biomaRt::getBM(attributes =attributes,filters=filters,values=x,mart = ensembl)
	newIdTable<-newIdTable[which(newIdTable[,1]!="" & newIdTable[,2]!=""),]
	if (verbose & any(table(newIdTable[,1])>1)) {
		message(paste0(length(which(table(newIdTable[,1])>1))," Ids can be converted to more than one ",attributes[2],", will use the first one."))
	}
	result<-newIdTable[match(x, newIdTable[,1]),2]
	if (verbose & any(is.na(result))) {
		message(paste0(length(which(is.na(result)))," Ids cant't be converted to ",attributes[2],", will be set as NA."))
	}
	names(result)<-x
	return(result)
}



