% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gc.R
\name{get_gc}
\alias{get_gc}
\title{Compute GC content}
\usage{
get_gc(ref, hgref = "hg19")
}
\arguments{
\item{ref}{GRanges object returned from \code{get_bam_bed}}

\item{hgref}{reference genome. This should be 'hg19', 'hg38' or 'mm10'.
Default is human genome \code{hg19}.}
}
\value{
\item{gc}{Vector of GC content for each bin/target}
}
\description{
Compute GC content for each bin
}
\examples{
\dontrun{
library(WGSmapp)
library(BSgenome.Hsapiens.UCSC.hg38)
bamfolder <- system.file('extdata', package = 'WGSmapp')
bamFile <- list.files(bamfolder, pattern = '*.dedup.bam$')
bamdir <- file.path(bamfolder, bamFile)
sampname_raw <- sapply(strsplit(bamFile, '.', fixed = TRUE), '[', 1)
bambedObj <- get_bam_bed(bamdir = bamdir,
                            sampname = sampname_raw, 
                            hgref = "hg38")
bamdir <- bambedObj$bamdir
sampname_raw <- bambedObj$sampname
ref_raw <- bambedObj$ref

gc <- get_gc(ref_raw, hgref = "hg38")
}

}
\author{
Rujin Wang \email{rujin@email.unc.edu}
}
