% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slots-generics.R, R/slots-methods.R
\docType{methods}
\name{assays}
\alias{assays}
\alias{FPKM}
\alias{FPKM<-}
\alias{variantFreq}
\alias{variantFreq<-}
\alias{counts,SGFeatureCounts-method}
\alias{counts<-,SGFeatureCounts-method}
\alias{FPKM,SGFeatureCounts-method}
\alias{FPKM<-,SGFeatureCounts-method}
\alias{counts,SGVariantCounts-method}
\alias{counts<-,SGVariantCounts-method}
\alias{FPKM,SGVariantCounts-method}
\alias{variantFreq,SGVariantCounts-method}
\alias{variantFreq<-,SGVariantCounts-method}
\title{Accessing and replacing assay data}
\usage{
FPKM(object, ...)

FPKM(object, ...) <- value

variantFreq(object)

variantFreq(object) <- value

\S4method{counts}{SGFeatureCounts}(object)

\S4method{counts}{SGFeatureCounts}(object) <- value

\S4method{FPKM}{SGFeatureCounts}(object)

\S4method{FPKM}{SGFeatureCounts}(object) <- value

\S4method{counts}{SGVariantCounts}(object, ...)

\S4method{counts}{SGVariantCounts}(object, ...) <- value

\S4method{FPKM}{SGVariantCounts}(object, ...)

\S4method{variantFreq}{SGVariantCounts}(object)

\S4method{variantFreq}{SGVariantCounts}(object) <- value
}
\arguments{
\item{object}{Object containing assay data}

\item{...}{Arguments passed to method for \code{SGVariantCounts} objects.
Argument \code{option} specifies whether the output should be based
on the count of fragments compatible with the variant at the start
(\dQuote{variant5p}), end (\dQuote{variant3p}) or either
(\dQuote{variant5pOr3p}) (the default), or whether output should be
based on the count of fragments compatible with any variant belonging
to the same event (\dQuote{event5p} or \dQuote{event3p}).
Argument \code{min_anchor} specifies the minimum anchor length when
computing FPKM values (defaults to 1).}

\item{value}{Replacement value}
}
\value{
Assay data for accessor functions or updated object for
  replacement functions.
}
\description{
Functions \code{counts} and \code{FPKM} are used to extract counts and
FPKM values from \code{SGFeatureCounts} and \code{SGVariantCounts}
objects. Function \code{variantFreq} is used to access relative usage
estimates from \code{SGVariantCounts} objects.
}
\examples{
x <- counts(sgfc_pred)
y <- FPKM(sgfc_pred)
u <- counts(sgvc_pred, option = "variant5p")
v <- FPKM(sgvc_pred, option = "variant5p")
}
\author{
Leonard Goldstein
}
