% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_label.r
\encoding{UTF-8}
\name{create.label}
\alias{create.label}
\title{Create a label list}
\usage{
create.label(label, case, meta=NULL, control=NULL, 
p.lab = NULL, n.lab = NULL, remove.meta.column=FALSE, verbose=1)
}
\arguments{
\item{label}{named vector to create the label or the name of the metadata
column that will be used to create the label}

\item{case}{name of the group that will be used as a positive label. If the
variable is binary, the other label will be used as a negative one. If the
variable has multiple values, all the other values will be used a negative
label (testing one vs rest).}

\item{meta}{metadata dataframe object or an object of class 
\link[phyloseq]{sample_data-class}}

\item{control}{name of a label or vector with names that will be used as a
negative label. All values that are nor equal to case and control will be
dropped. Default to NULL in which case: If the variable is binary, the value
not equal to case will be used as negative. If the variable has multiple
values, all the values not equal to cases will be used a negative label
(testing one vs rest).}

\item{p.lab}{name of the positive group (useful mostly for visualizations).
Default to NULL in which case the value of the positive group will be used.}

\item{n.lab}{name of the negative group (useful mostly for visualizations).
Default to NULL in which case the value of the negative group will be used
for binary variables and "rest" will be used for variables with multiple
values.}

\item{remove.meta.column}{boolean indicating if the label column in the
metadata should be retained. Please note that if this is set to
\code{TRUE}, the function will return a list as result. Defaults to
\code{FALSE}}

\item{verbose}{integer, control output: \code{0} for no output at all, 
\code{1} for only information about progress and success, \code{2} for 
normal level of information and \code{3} for full debug information, 
defaults to \code{1}}
}
\value{
return either \itemize{
\item a list to be used in a SIMCAT object \strong{OR}
\item a list with entries \code{meta} and \code{label},
if \code{remove.meta.column} is set to \code{TRUE}
}
}
\description{
This function creates a label object from metadata
or an atomic vector
}
\details{
The function creates a list to be used as label in a SIAMCAT
object. Mainly for interal use, but it can be used to customize your label
(\code{p.lab} and \code{n.lab} will be used as labels during plotting,
for example).

The input for the function can be either a named vector encoding the label
or the name of a column in the metadata (needs to be provided as well) which
contains the label information.
}
\examples{
data('meta_crc_zeller')

label <- create.label(label='Group', case='CRC', meta=meta.crc.zeller)
}
\keyword{create.label}
