% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{eval_data}
\alias{eval_data}
\alias{eval_data,siamcat-method}
\title{Retrieve the evaluation metrics from a SIAMCAT object}
\usage{
eval_data(siamcat, verbose=1)

\S4method{eval_data}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). A \link{siamcat-class} object
that contains evaluation data}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
The list of evaluation data or \code{NULL}
}
\description{
Function to retrieve the evaluation metrics from a SIAMCAT
object
}
\details{
The functions returns a list containing the evaluation metrics from
a SIAMCAT object. See \link{evaluate.predictions} for more information on
evaluation data.
}
\examples{
data(siamcat_example)
temp <- eval_data(siamcat_example)
names(temp)
temp$auroc
}
