% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefseformat.R
\name{read.lefse}
\alias{read.lefse}
\title{read an input file in a LEfSe input format}
\usage{
read.lefse(filename = "data.txt", rows.meta = 1, row.samples = 2)
}
\arguments{
\item{filename}{name of the input file in a LEfSe input format}

\item{rows.meta}{specifies in which rows medata variables are stored}

\item{row.samples}{specifies in which row sample names are stored}
}
\value{
a list with two elements: \itemize{
    \item \code{feat} a features matrix
    \item \code{meta} a metadate matrix}
}
\description{
This reads an input file in a LEfSe input format
}
\examples{

fn.in.lefse<- system.file("extdata",
"LEfSe_crc_zeller_msb_mocat_specI.tsv",package = "SIAMCAT")
meta.and.features <- read.lefse(fn.in.lefse, rows.meta = 1:6,
row.samples = 7)
meta <- meta.and.features$meta
feat <- meta.and.features$feat
label <- create.label(meta=meta, label="label", case = "cancer")
siamcat <- siamcat(feat=feat, label=label, meta=meta)

}
\keyword{internal}
\keyword{read.lefse}
