% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_features.R
\encoding{UTF-8}
\name{summarize.features}
\alias{summarize.features}
\title{Summarize features}
\usage{
summarize.features(siamcat, level = 'g__', 
feature.type='original', verbose=1)
}
\arguments{
\item{siamcat}{object of class \link{siamcat-class}}

\item{level}{string, at which level to summarize (e.g. \code{g__} = genus)}

\item{feature.type}{string, on which type of features should the function
work? Can be either \code{"original"}, \code{"filtered"}, or
\code{"normalized"}. Please only change this paramter if you know what
you are doing!}

\item{verbose}{integer, control output: \code{0} for no output at all,
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
object of class \link{siamcat-class} with a summarized feature table
}
\description{
This function summarize features on a specific taxonomic level
}
\details{
This function will summarize features at different taxonomic
levels, e.g. transform species-level relative abundance into genus-level
taxonomic profiles.

The function expects a SIAMCAT object that either contains an entry in the
\link[phyloseq]{tax_table} slot of its \link{phyloseq} object, \strong{OR}
a set of feature names which encode taxonomic information, e.g.

\code{k__Bacteria;p__Actinobacteria;c__Actinobacteria;o__Acidimicrobiales;..}

Then, for a given taxonomic level (e.g. \code{g__}), the function will
sum up all the relative abundances of features belonging to the same group
at that specific taxonomic level.

\strong{Please note that this function is currently maturing and not
necessarily reliable!!!}
}
\examples{
## load the phyloseq example data
data("GlobalPatterns")
## create an example label
label <- create.label(meta=sample_data(GlobalPatterns),
    label = "SampleType",
    case = c("Freshwater", "Freshwater (creek)", "Ocean"))
# run the constructor function
siamcat <- siamcat(phyloseq=GlobalPatterns, label=label, verbose=1)
siamcat <- summarize.features(siamcat, level='Genus', verbose=3)
}
\keyword{internal}
