% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_model.r
\encoding{UTF-8}
\name{train.model}
\alias{train.model}
\title{Model training}
\usage{
train.model(siamcat, method = "lasso", measure = "classif.acc",
param.set = NULL, grid.size=11, min.nonzero=5, perform.fs = FALSE,
param.fs = list(no_features = 100, method = "AUC", direction="absolute"),
feature.type='normalized', verbose = 1)
}
\arguments{
\item{siamcat}{object of class \link{siamcat-class}}

\item{method}{string, specifies the type of model to be trained, may be one
of these: \code{c('lasso', 'enet', 'ridge', 'lasso_ll', 'ridge_ll',
'randomForest')}}

\item{measure}{character, specifies the model selection criterion during
internal cross-validation, see \link[mlr3]{mlr_measures} for more details,
defaults to \code{'classif.acc'}}

\item{param.set}{list, set of extra parameters for mlr, see below for
details, defaults to \code{NULL}}

\item{grid.size}{integer, grid size for internal tuning (needed for some
machine learning methods, for example \code{lasso_ll}), defaults to
\code{11}}

\item{min.nonzero}{integer number of minimum nonzero coefficients that
should be present in the model (only for \code{'lasso'}, \code{'ridge'},
and \code{'enet'}), defaults to \code{5}}

\item{perform.fs}{boolean, should feature selection be performed? Defaults
to \code{FALSE}}

\item{param.fs}{list, parameters for the feature selection, see Details,
defaults to \code{list(thres.fs=100, method.fs="AUC", direction='absolute')}}

\item{feature.type}{string, on which type of features should the function
work? Can be either \code{"original"}, \code{"filtered"}, or
\code{"normalized"}. Please only change this paramter if you know what you
are doing!}

\item{verbose}{integer, control output: \code{0} for no output at all,
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
object of class \link{siamcat-class} with added \code{model_list}
}
\description{
This function trains the a machine learning model on the
training data
}
\section{Machine learning methods}{

This functions performs the training of the machine learning model
and functions as an interface to the \code{mlr3}-package.

The function expects a \link{siamcat-class}-object with a prepared
cross-validation (see \link{create.data.split}) in the
\code{data_split}-slot of the object. It then trains a model for each fold
of the data split.

The different machine learning methods are implemented as Learners from the
\link{mlr3learners} package:
\itemize{
\item \code{'lasso'}, \code{'enet'}, and \code{'ridge'} use the
\code{'classif.cv_glmnet'} or \code{'regr.cv_glmnet'} Learners, which
interface to the \link{glmnet} package,
\item \code{'lasso_ll'} and \code{'ridge_ll'} use a custom Learner, which
is only available for classification tasks. The underlying package is the
\link{LiblineaR} packge.
\item \code{'randomForest'} is implemented via the \code{'classif.ranger'}
or \code{regr.ranger} Learners available trough the \link[ranger]{ranger}
package.}
}

\section{Hyperparameter tuning}{

There is additional control over the machine learning procedure by
supplying information through the \code{param.set} parameter within the
function. We encourage you to check out the excellent
\href{https://mlr3book.mlr-org.com/optimization.html}{mlr documentation}
for more in-depth information.

Here is a short overview which parameters you can supply in which form:
\itemize{
\item enet The \strong{alpha} parameter describes the mixture between
lasso and ridge penalty and is -per default- determined using internal
cross-validation (the default would be equivalent to
\code{param.set=list('alpha'=c(0,1))}). You can supply either the limits of
the hyperparameter exploration (e.g. with limits 0.2 and 0.8:
\code{param.set=list('alpha'=c(0.2,0.8))}) or you can supply a fixed alpha
value as well (\code{param.set=list('alpha'=0.5)}).
\item lasso_ll/ridge_ll You can supply both \strong{class.weights} and
the \strong{cost} parameter (cost of the constraints violation, see
\link[LiblineaR]{LiblineaR} for more info). The default values would be
equal to \code{param.set=list('class.weights'=c(5, 1),
'cost'=c(-2, 3))}.
\item randomForest You can supply the two parameters \strong{num.trees}
(Number of trees to grow) and \strong{mtry} (Number of variables randomly
sampled as candidates at each split). See also
\link[ranger]{ranger} for more info. The default values
correspond to
\code{param.set=list('num.trees'=c(100, 1000), 'mtry'=
c(round(sqrt.mdim / 2), round(sqrt.mdim), round(sqrt.mdim * 2)))} with
\code{sqrt.mdim=sqrt(nrow(data))}.
}
}

\section{Feature selection}{

If feature selection should be performed (for example for functional data
with a large number of features), the \code{param.fs} list should contain:
\itemize{ \item \code{no_features} - Number of features to be retained after
feature selection,
\item \code{method} - method for the feature selection, may be
\code{AUC}, \code{gFC}, or \code{Wilcoxon} for binary classification
problems or \code{spearman}, \code{pearson}, or \code{MI} (mutual
information) for regression problems
\item \code{direction} - indicates if the feature selection should be
performed in a single direction only. Can be either \itemize{
\item \code{absolute} -  select the top associated features (independent of
the sign of enrichment),
\item \code{positive}the top positively associated featured (enriched in
the case group for binary classification or enriched in higher values
for regression),
\item \code{negative} the top negatively associated features (inverse of
positive)} Direction will be ignored for \code{Wilcoxon} and \code{MI}.}
}

\examples{
data(siamcat_example)

# simple working example
siamcat_example <- train.model(siamcat_example, method='lasso')
}
\keyword{SIAMCAT}
\keyword{plm.trainer}
